/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import noppes.npcs.api.IPos;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.IEntityLiving;
import noppes.npcs.api.entity.IEntityLivingBase;
import noppes.npcs.api.wrapper.BlockPosWrapper;
import noppes.npcs.api.wrapper.EntityLivingBaseWrapper;

public class EntityLivingWrapper<T extends EntityLiving>
extends EntityLivingBaseWrapper<T>
implements IEntityLiving {
    public EntityLivingWrapper(T entity) {
        super(entity);
    }

    @Override
    public boolean canSeeEntity(IEntity entity) {
        return ((EntityLiving)this.entity).func_70635_at().func_75522_a(entity.getMCEntity());
    }

    @Override
    public void clearNavigation() {
        ((EntityLiving)this.entity).func_70661_as().func_75499_g();
    }

    @Override
    public IEntityLivingBase getAttackTarget() {
        IEntityLivingBase base = (IEntityLivingBase)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)((EntityLiving)this.entity).func_70638_az());
        return base != null ? base : super.getAttackTarget();
    }

    @Override
    public IPos getNavigationPath() {
        if (!this.isNavigating()) {
            return null;
        }
        PathPoint point = Objects.requireNonNull(((EntityLiving)this.entity).func_70661_as().func_75505_d()).func_75870_c();
        if (point == null) {
            return null;
        }
        return new BlockPosWrapper(new BlockPos(point.field_75839_a, point.field_75837_b, point.field_75838_c));
    }

    @Override
    public boolean isAttacking() {
        return super.isAttacking() || ((EntityLiving)this.entity).func_70638_az() != null;
    }

    @Override
    public boolean isNavigating() {
        return !((EntityLiving)this.entity).func_70661_as().func_75500_f();
    }

    @Override
    public void jump() {
        ((EntityLiving)this.entity).func_70683_ar().func_75660_a();
    }

    @Override
    public void navigateTo(double x, double y, double z, double speed) {
        ((EntityLiving)this.entity).func_70661_as().func_75499_g();
        ((EntityLiving)this.entity).func_70661_as().func_75492_a(x, y, z, speed * 0.7);
    }

    @Override
    public void navigateTo(Integer[][] posses, double speed) {
        PathNavigate nav = ((EntityLiving)this.entity).func_70661_as();
        nav.func_75499_g();
        ArrayList<PathPoint> points = new ArrayList<PathPoint>();
        for (Integer[] posId : posses) {
            if (posId == null || posId.length < 3) {
                return;
            }
            points.add(new PathPoint(posId[0].intValue(), posId[1].intValue(), posId[2].intValue()));
        }
        nav.func_75484_a(new Path(points.toArray(new PathPoint[0])), speed);
    }

    @Override
    public void setAttackTarget(IEntityLivingBase living) {
        if (living == null) {
            ((EntityLiving)this.entity).func_70624_b(null);
        } else {
            ((EntityLiving)this.entity).func_70624_b(living.getMCEntity());
        }
        super.setAttackTarget(living);
    }
}

